/**************************************************************
        Schemat podcze programowanego ukadu
                       +----v----+
                 MCLR [| 1     28|] VDD
                  RA0 [| 2     27|] VSS
                  RA1 [| 3     26|] RB15 -> DB4        
           SDO <- RP0 [| 4     25|] RB14 -> DB5
           SCK <- RP1 [| 5     24|] RB13 -> DB6
            SS <- RP2 [| 6     23|] 
           SDI -> RP3 [| 7     22|] RB11 -> DB7
                  VSS [| 8     21|] RB10 -> RS
       (8 MHz) / OSCI [| 9     20|] VCAP/VDDCORE
               \ OSCO [|10     19|] DISVREG
                      [|11     18|] RB9 -> EN
                      [|12     17|] 
                  VDD [|13     16|]  
                      [|14     15|] 
                       +---------+
                     PIC24FJ64GB002
***************************************************************/
#include <p24FJ64GB002.h>
//definiujemy szybko oscylatora dla funkcji __delay_
#define FCY 16000000UL 
//biblioteka z funkcjami __delay_us i __delay_ms
#include <libpic30.h>
//biblioteka FAT16
#include "FSIO.h"

//ustawienia bitw konfiguracyjnych
//1. 
//FWDTEN_OFF - Watchdog wyczony
//JTAGEN_OFF - JTAG wyczony
_CONFIG1(FWDTEN_OFF & JTAGEN_OFF)
//2.
//FNOSC_PRIPLL - ukad taktowany zewntrznym oscylatorem z ptl PLL
//POSCMOD_XT - czstotliwo taktowania oscylatora 8 MHz
//PLLDIV_DIV2 - konieczno podzielenia przez 2 dla moduu USB PLL
_CONFIG2(FNOSC_PRIPLL & POSCMOD_XT & PLLDIV_DIV2)
//////////////////////////////////////
#define TRIS_RS_LCD   TRISBbits.TRISB10
#define TRIS_EN_LCD   TRISBbits.TRISB9
#define TRIS_DB4_LCD  TRISBbits.TRISB15
#define TRIS_DB5_LCD  TRISBbits.TRISB14
#define TRIS_DB6_LCD  TRISBbits.TRISB13
#define TRIS_DB7_LCD  TRISBbits.TRISB11

#define RS_LCD   LATBbits.LATB10
#define EN_LCD   LATBbits.LATB9
#define DB4_LCD  LATBbits.LATB15
#define DB5_LCD  LATBbits.LATB14
#define DB6_LCD  LATBbits.LATB13
#define DB7_LCD  LATBbits.LATB11

#include "lcd.h"
//////////////////////////////////////
char tablica[128];				//tablica danych
char napisik[] = "Mikrokontrolery PIC w praktycznych zastosowaniach";

//tablice znakowe dla funkcji LCD
char napis0[] = "Szukam karty SD";	//15 znakw
char napis1[] = "Nie mam kontaktu";	//16 znakw
char napis2[] = "Mam kontakt z SD";	//16 znakw
char napis3[] = "Blad zapisu!";		//12 znakw
char napis4[] = "Blad odczytu!";	//13 znakw

int main()
{
	FSFILE *plik;				//wskanik do pliku
	/////////////////////////////////////////////////////
	AD1PCFGL = 0xFFFF;			//wszystkie linie cyfrowe

	/////////////////////////////////////////////////////
	//uruchomienie wywietlacza LCD//////////////////////
	WlaczLCD();					//inicjalizacja wywietlacza LCD
	WyswietlLCD(napis0, 15);	//wywietl napis "Szukam karty SD"

	/////////////////////////////////////////////////////
	// obsuga SPI1
	//remapowanie linii portw dla interfejsu SPI
	//linie wyjciowe
	//1. RP0 -> SDO1 (funkcja nr 7)
	RPOR0bits.RP0R = 7;
	//2. RP1 -> SCK1OUT (funkcja nr 8)
	RPOR0bits.RP1R = 8;
	//3. RP2 -> SS1OUT
	RPOR1bits.RP2R = 9;
	//linia wejciowa
	//4. RP3 <- SDI1 (linia nr 3)
	RPINR20bits.SDI1R = 3;

	/////////////////////////////////////////////////////
	// inicjalizacja karty SD i interfejsu SPI1
	while(!FSInit())
	{
		CzyscLCD();					//resetuj pami wywietlacza
		WyswietlLCD(napis1, 16);	//wywietl napis "Nie mam kontaktu"
		__delay_ms(1000);			//zaczekaj 1 s
	}
	/////////////////////////////////////////////////////
	//inicjalizacja SD i SPI przebiega poprawnie
	CzyscLCD();						//resetuj pami wywietlacza
	WyswietlLCD(napis2, 16);		//wywietl napis "Mam kontakt z SD"

	/////////////////////////////////////////////////////
	//zapisz dane w pliku PLIK2.TXT
	//otwrz plik w trybie do zapisu
	plik = FSfopen("PLIK2.TXT", "w");
	if(plik == NULL)				//jeli prba si nie powioda
	{
		CzyscLCD();					//resetuj pami wywietlacza
		WyswietlLCD(napis3, 12);	//wywietl napis "Blad zapisu!"
	}
	else							//jeli prba udana
	{
		//zapisz dane do pliku
		FSfwrite((void*)napisik, 49, 1, plik);
		FSfclose(plik);				//zamknij plik
	}

	/////////////////////////////////////////////////////
	//odczytaj dane z pliku PLIK1.TXT
	//otwrz plik w trybie do odczytu
	plik = FSfopen("PLIK1.TXT", "r");
	if(plik == NULL)				//jeli prba si nie powioda
	{
		UstawKursorLCD(2, 1);		//przejd do wiersza 2.
		WyswietlLCD(napis4, 13);	//wywietl napis "Blad odczytu!"
	}
	else							//jeli prba udana
	{
		//odczytaj 10 bajtw danych z pliku
		FSfread(tablica, 10, 1, plik);
		FSfclose(plik);				//zamknij plik
		UstawKursorLCD(2, 1);		//przejd do wiersza 2.
		WyswietlLCD(tablica, 10);	//wywietl odczytanych 10 bajtw
	}

	/////////////////////////////////////////////////////
	//nieskoczona ptla
	for(;;)						
	{
	}

}
